// GLOBALE VARIABLE
var datengeladen = false;
var urlsfetched = false;
var urlliste = [];
var landesurlliste = {};
var landeskuerzel = null;
var openurl = false;
var getlandesurl = false;
var tbl = {
	'input': 'UI#popup#table#urlliste#body#input',
	'output': 'UI#popup#table#urlliste#body#output',
}


// BEIM LADEN AUSFÜHREN
document.addEventListener('DOMContentLoaded', function() {
	// Listeners hinzufügen:
	document.getElementsByName('UI#popup#btn#unterseite').forEach(function(el) {
		el.onclick = function(event) {handler.unterseite(event,event.target.getAttribute('wert'));};
	});
	document.getElementById('UI#popup#anleitung#btn').onclick = function(event) {handler.aufklappen(event.target);};
	document.getElementById('UI#popup#btn#erzeugen').onclick = function(event) {handler.erzeugen();};
	document.getElementById('UI#popup#btn#kopieren').onclick = function(event) {handler.kopieren(event.target.getAttribute('wert'))};
	document.getElementById('UI#popup#btn#unterseite').onclick = function(event) {handler.unterseite(event,event.target.getAttribute('wert'));};
	document.getElementById('UI#popup#btn#landeskuerzel').addEventListener('focusout',function(event) {handler.hochladenland(event.target.value)},false);
	document.getElementById(tbl['input']).addEventListener('focusout',function(event) {handler.hochladen()},false);

	// Einmalig ausführen:
	chrome.runtime.sendMessage({from: 'popup.js', to: 'background.js', subject: 'Popup geladen'}, handler.initialisieren);

	// NACHRICHTEN LAUSCHEN:
	chrome.runtime.onMessage.addListener(function (msg,sender,reply) {
		if((msg.from=='background.js') && (msg.subject=='Landes-URLs generiert')) {
			landeskuerzel = msg.land;
			landesurlliste = JSON.parse(msg.daten);
			urlliste = Object.keys(landesurlliste);
			urlsfetched = true;
			handler.output();
		} else if((msg.from=='background.js') && (msg.subject=='Fortschritt bei der Erzeugung von Landes-URLs')) {
			var t = msg.zeit;
			var T = msg.ende;
			document.getElementById('UI#popup#progressmeter#outer').textContent = t+'/'+T+'; '+Math.round(100*t/T)+'%';
		}
	});
});


// EVENT HANDLER
var handler = {
	'unterseite': function(event,url) {
		if(event.metaKey || event.ctrlKey) {
			var target = '_blank';
		} else {
			var target = '_self';
		}
		response.unterseite(url,target);
	},
	'initialisieren': function(msg) {
		datengeladen = msg.bool;
		urlsfetched = msg.fetched;
		if(datengeladen) {
			landeskuerzel = msg.land;
			document.getElementById('UI#popup#btn#landeskuerzel').value = landeskuerzel;
			landesurlliste = JSON.parse(msg.daten);
			urlliste = Object.keys(landesurlliste);
			handler.input();
			if(urlsfetched) handler.output();
		}
		response.steuerelemente.disable(false);
	},
	'input': function() {
		var list = [];
		urlliste.forEach(function(url) {
			landesurlliste[url].idx.forEach(function(j) {
				list[j] = url;
			});
		});
		document.getElementById(tbl['input']).value = list.join('\n');
	},
	'output': function() {
		var list = document.getElementById(tbl['input']).value.split('\n');
		var list_out = [];
		urlliste.forEach(function(url) {
			var landesurl = landesurlliste[url].landesurl;
			landesurlliste[url].idx.forEach(function(j) {
				list_out[j] = landesurl;
			});
		});
		document.getElementById(tbl['output']).value = list_out.join('\n');
	},
	'kopieren': function(id) {
		tbl = document.getElementById(id);
		var output = {
			erfolg: function() {},
			misserfolg: function() {},
			fehler: function() {alert('Nicht unterstützt vom Browser!');},
		};
		GLOB.handler.kopieren.bereitstellen(tbl,output);
	},
	'hochladen': function() {
		var list = document.getElementById(tbl['input']).value.split('\n');
		urlliste = Array.from(new Set(list));
		landesurlliste = {};
		list.forEach(function(url,i) {
			if(!landesurlliste.hasOwnProperty(url)) landesurlliste[url] = {idx: [], landesurl: null};
			landesurlliste[url].idx.push(i);
		});
		landeskuerzel = document.getElementById('UI#popup#btn#landeskuerzel').value;
		landeskuerzel = landeskuerzel.replace(/\s/g,function() {return '';});
		chrome.runtime.sendMessage({from: 'popup.js', to: 'background.js', subject: 'URLs hochgeladen', daten: JSON.stringify(landesurlliste), land:landeskuerzel});
		datengeladen = true;
	},
	'hochladenland': function(wert) {
		landeskuerzel = wert.replace(/\s/g,function() {return '';});
		chrome.runtime.sendMessage({from: 'popup.js', to: 'background.js', subject: 'Landeskürzel geändert', land:landeskuerzel});
	},
	'erzeugen': function() {
		if(!datengeladen) handler.hochladen();
		chrome.runtime.sendMessage({from: 'popup.js', to: 'background.js', subject: 'erzeuge Landes-URLs!'});
	},
	'aufklappen': function(btn) {
		btn.blur;
		var div = document.getElementById('UI#popup#anleitung');
		if(div.style.display == 'none') {
			div.style.display = 'inline-block';
			btn.value = '▲ Anleitung zuklappen'; //müsste mit &#x25B2; klappen.
		} else {
			div.style.display = 'none';
			btn.value = '▼ Anleitung aufklappen'; //müsste mit &#x25BC; klappen.
		}
	},
};


// RESPONSE-FUNKTIONEN
var response = {
	'unterseite': function(url,target) {
		chrome.tabs.query({active: true, currentWindow: true}, function (tabs) {
			chrome.tabs.sendMessage(tabs[0].id, {from: 'popup.js', to: 'content.js', subject: 'öffne URL!', url:url, target: target});
		});
	},
	'meldung':  function(str,alerttyp) {
		var text = document.getElementById('UI#popup#div#meldung#text');
		text.textContent = str;
		if(alerttyp == 'alert') {
			text.style.color = 'red';
		} else if (alerttyp == 'command') {
			text.style.color = 'blue';
		} else {
			text.style.color = '';
		}
	},
	'steuerelemente': {
		'disable': function(opt) {
			var element = document.getElementsByClassName('steuerelemente');
			for(var i=0; i<element.length; i++) {
				var btn = element[i].getElementsByTagName('input');
				for(var k=0; k<btn.length; k++) {
					btn[k].classList.contains('btn-zwischenlager') ? btn[k].disabled = false : btn[k].disabled = opt;
				}
			}
			document.getElementById(tbl['input']).disabled = opt;
			document.getElementById(tbl['output']).disabled = true;
			document.getElementById('UI#popup#btn#kopieren').disabled = false;
			document.getElementById('UI#popup#btn#unterseite').disabled = true;
		},
	},
	'progressmeter': {
		'initialisieren': function(bar) {
			this.display(bar,0,1);
		},
		'display': function(bar,p,q) {
			var r = 1;
			if(q > 0) {
				var r = Math.min(p/q,1);
			}
			bar.style.width = 100*r+'%';
			if(p < q) {
				bar.classList.remove('progressmeter-full');
				bar.classList.add('progressmeter-pc');
			} else {
				bar.classList.remove('progressmeter-pc');
				bar.classList.add('progressmeter-full');
			}
		},
	},
}